<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");
include("adminlogs/admin_logs.php");
include("sendemail/sendMail.php");
include("allmails/allMail.php");

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $adminId = isset($_POST['adminId']) ? mysqli_real_escape_string($conn, $_POST['adminId']) : null;
    $id = isset($_POST['id']) ? mysqli_real_escape_string($conn, $_POST['id']) : null;
    $senderid = isset($_POST['senderid']) ? mysqli_real_escape_string($conn, $_POST['senderid']) : null;
    $clientId = isset($_POST['clientId']) ? mysqli_real_escape_string($conn, $_POST['clientId']) : null;


    // Check if either logo or fav icon is present
    if (isset($_FILES['NOC']) || isset($_FILES['BR'])) {

        // File handling for NOC
        $NOCPath = isset($_FILES['NOC']) ? handleFile($_FILES['NOC'], 'NOC', $id) : null;

        // File handling for BR icon
        $BRPath = isset($_FILES['BR']) ? handleFile($_FILES['BR'], 'BR', $id) : null;

        // Perform database updates and log entries
        if ($NOCPath !== false || $BRPath !== false) {
            // Build update query based on available files
            $updateQuery = "UPDATE sender_details SET ";
            if ($NOCPath !== null) {
                $updateQuery .= "`noc_letter` = '$NOCPath', ";
            }
            if ($BRPath !== null) {
                $updateQuery .= "`br_upload` = '$BRPath', ";
            }
            $updateQuery = rtrim($updateQuery, ", ") . " WHERE `s_id` = '$id'";

            $updateResult = mysqli_query($conn, $updateQuery);

            if ($updateResult) {

                // Select the client 
                $selectQuery = "SELECT * FROM clients WHERE `c_id` = '$clientId'";
                $selectResult = mysqli_query($conn, $selectQuery);

                $row_count = mysqli_num_rows($selectResult);
                if ($row_count < 1) {
                    throw new Exception('Client not found');
                }

                $client_data = mysqli_fetch_assoc($selectResult);

                $c_mail = $client_data["email"];
                $client_name = $client_data["f_name"] . " " . $client_data["l_name"];
                $email_sub = $client_data["email_subscribe"];

                $query_system = "SELECT * FROM system_setting";

                $result_system = mysqli_query($conn, $query_system);

                if (mysqli_num_rows($result_system) > 0) {
                    $row_system = mysqli_fetch_assoc($result_system);
                    //pass row-system to email

                    if ($email_sub == 1) {

                        $mailCont = uploadDocumentSenderid($row_system, $client_name, $c_mail, $senderid, $NOCPath, $BRPath);

                        $postFileds = [
                            'to' => $c_mail, // Recipient's email address
                            'sub' => "Documents Uploaded Successfully - $senderid", // Email subject
                            'msg' => $mailCont, // HTML content of the email
                            'from' => 'hello@ozonesender.com' // Sender's email address billing@ozonesender.com For Billing , hello@ozonesender.com For General
                        ];

                        $sms_details = sendMail($postFileds);

                        $sms_details_array = json_decode($sms_details, true);
                    }
                    // Log entries for successful upload
                    $response = array('success' => true, 'message' => 'Files uploaded successfully');

                    $by = $adminId;
                    $date = date('Y-m-d H:i:s');
                    $module = 'Upload Document';
                    $message = "Administrator $adminId has successfully uploaded the Document for senderid($id).";

                    insertAdminLog($conn, $by, $date, $module, $message);
                } else {
                    throw new Exception("system data not found");
                }
            } else {
                $response = array('success' => false, 'message' => 'Database update failed');
            }
        } else {
            $response = array('success' => false, 'message' => 'File upload failed');
        }

        echo json_encode($response);
    } else {
        throw new Exception('Either logo or fav icon is required');
    }
} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}

// Function to handle file upload
function handleFile($file, $moduleName, $id)
{
    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, "http://file.ozonedesk.info/upload.php");
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, array(
        'file' => new CURLFile($file['tmp_name'], $file['type'], $file['name']),
        'client_id' => 1001,
        'api_key' => 'os-1121',
        'module' => $moduleName,
        'module_id' => "$id"
    ));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $result = curl_exec($ch);

    curl_close($ch);

    $arr = json_decode($result, true);

    $arrstatus = $arr["status"];
    $arrfile_path = $arr["file_path"];
    $arrmodule = $arr["module"];
    $arrmodule_id = $arr["module_id"];

    // Handle the response as needed
    if ($arrstatus == "200" && $arrmodule == $moduleName && $arrmodule_id == "$id") {
        return $arrfile_path; // Return the file path for successful upload
    } else {
        return false; // Return false for unsuccessful upload
    }
}
