<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/x-www-form-urlencoded; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");
include("adminlogs/admin_logs.php");
include("notification/client_notification.php");
include("jwtvalidation/jwt_validation.php");
require 'secret_key.php';
include("sendemail/sendMail.php");
include("allmails/allMail.php");

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];


    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $id = isset($data['id']) ? mysqli_real_escape_string($conn, $data['id']) : null;
    $amount = isset($data['amount']) ? mysqli_real_escape_string($conn, $data['amount']) : null;
    $invoiceNo = isset($data['invoiceNo']) ? mysqli_real_escape_string($conn, $data['invoiceNo']) : null;
    $adminId = isset($data['adminId']) ? mysqli_real_escape_string($conn, $data['adminId']) : null;


    // Select the current balance
    $selectQuery = "SELECT * FROM clients WHERE `c_id` = '$id'";
    $selectResult = mysqli_query($conn, $selectQuery);

    $row_count = mysqli_num_rows($selectResult);

    if ($row_count === 1) {
        $client_data = mysqli_fetch_assoc($selectResult);

        // Update the current balance
        $currentBalance = $client_data['current_balance'];
        $updatedBalance = $currentBalance + $amount;

        $c_mail = $client_data["email"];
        $client_name = $client_data["f_name"] . " " . $client_data["l_name"];
        $company_name = $client_data["company_name"];
        $c_mobile = $client_data["mobile"];

        $date = date('Y-m-d H:i:s');

        $updateQuery = "UPDATE clients SET `current_balance` = '$updatedBalance', low_bal_status = 0,productive_cli = 1 WHERE `c_id` = '$id'";
        $updateResult = mysqli_query($conn, $updateQuery);


        $addTopupquery = "INSERT INTO topup_history (`datetime`, `current_balance`, `new_balance`, `topup`, `user_id`, `by`) VALUES ('$date', '$currentBalance', '$updatedBalance', '$amount', '$id', '0')";

        $result = mysqli_query($conn, $addTopupquery);

        $accountquery = "INSERT INTO account_history (`datetime`, `current_balance`, `new_balance`, `cost`, `type`, `byID`, `whose`) VALUES ('$date', '$currentBalance', '$updatedBalance', '$amount', 'topup', '$id', '$id')";

        $resultAccount = mysqli_query($conn, $accountquery);

        $updateinvoice_query = "UPDATE invoice_details set `status` = 'paid', `date` = '$date' WHERE `invoice_HID` = '$invoiceNo'";

        $updateinvoice_result = mysqli_query($conn, $updateinvoice_query);

        if ($updateResult && $result && $resultAccount && $updateinvoice_result) {
            // get invoice details
            $query_invoice = "SELECT * FROM invoice_details WHERE invoice_HID = '$invoiceNo'";

            $result_invoice = mysqli_query($conn, $query_invoice);

            if (mysqli_num_rows($result_invoice) > 0) {

                $row_invoice = mysqli_fetch_assoc($result_invoice);

                $total = $row_invoice['total'];
                $date = $row_invoice['date'];
                $description = $row_invoice['description'];

                $query_system = "SELECT * FROM system_setting";

                $result_system = mysqli_query($conn, $query_system);

                if (mysqli_num_rows($result_system) > 0) {
                    $row_system = mysqli_fetch_assoc($result_system);
                    //pass row-system to email

                    $mailCont = clientTopup($invoiceNo, $date, $total, $row_system, $client_name, $c_mail, $company_name, $c_mobile, $description,  $currentBalance, $amount, $updatedBalance);

                    $postFileds = [
                        'to' => $c_mail, // Recipient's email address
                        'sub' => "SMS Top-Up Payment Confirmation - Invoice $invoiceNo", // Email subject
                        'msg' => $mailCont, // HTML content of the email
                        'from' => 'billing@ozonesender.com' // Sender's email address billing@ozonesender.com For Billing , hello@ozonesender.com For General
                    ];

                    $sms_details = sendMail($postFileds);

                    $sms_details_array = json_decode($sms_details, true);

                    $status_code = $sms_details_array['response']['ErrorCode'];
                    $msg_id = $sms_details_array['response']['MessageID'];

                    $response = array('success' => true, 'message' => 'Balance updated successfully');

                    $by = $userId;
                    $date = date('Y-m-d H:i:s');
                    $module = 'Update Topup';
                    $message = "Administrator $userId has successfully updated the Topup balance by $amount for Client $id.";

                    insertAdminLog($conn, $by, $date, $module, $message);

                    // notification
                    $title = 'Update Topup';
                    $date = date('Y-m-d H:i:s');
                    $subtitle = "The top-up amount is $amount, the updated balance is $updatedBalance.";
                    $avatar = 'TP';
                    $client_id = $id;

                    insertNotification($conn, $title, $date, $subtitle, $avatar, $client_id);
                } else {
                    throw new Exception("system data not found");
                }
            } else {
                throw new Exception("invoices not found");
            }

           
        } else {
            $response = array('success' => false, 'message' => 'Failed to update balance');
        }
    } else {
        // Authentication failed
        $response = array('success' => false, 'message' => 'Invalid user id');
    }

    echo json_encode($response);
} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
