<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");
include("adminlogs/admin_logs.php");
include("jwtvalidation/jwt_validation.php");
require 'secret_key.php';

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

     // Validate the JWT token
     $headers = apache_request_headers();
     $secretKey = $secret_Key;
     $decodedToken = validateJWT($headers, $secretKey);

     $userId = $decodedToken['user_id'];

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $companyName = isset($data['companyName']) ? mysqli_real_escape_string($conn, $data['companyName']) : null;
    $address1 = isset($data['address1']) ? mysqli_real_escape_string($conn, $data['address1']) : null;
    $address2 = isset($data['address2']) ? mysqli_real_escape_string($conn, $data['address2']) : null;
    $phone = isset($data['phone']) ? mysqli_real_escape_string($conn, $data['phone']) : null;
    $defaultregfee = isset($data['defaultregfee']) ? mysqli_real_escape_string($conn, $data['defaultregfee']) : null;
    $defaultsenderidfee = isset($data['defaultsenderidfee']) ? mysqli_real_escape_string($conn, $data['defaultsenderidfee']) : null;
    $accountName = isset($data['accountName']) ? mysqli_real_escape_string($conn, $data['accountName']) : null;
    $bankName = isset($data['bankName']) ? mysqli_real_escape_string($conn, $data['bankName']) : null;
    $accountNo = isset($data['accountNo']) ? mysqli_real_escape_string($conn, $data['accountNo']) : null;
    $branch = isset($data['branch']) ? mysqli_real_escape_string($conn, $data['branch']) : null;
    $swiftCode = isset($data['swiftCode']) ? mysqli_real_escape_string($conn, $data['swiftCode']) : null;
    $merchantId = isset($data['merchantId']) ? mysqli_real_escape_string($conn, $data['merchantId']) : null;
    $merchantSecretKey = isset($data['merchantSecretKey']) ? mysqli_real_escape_string($conn, $data['merchantSecretKey']) : null;
    $gatewayFixedAmount = isset($data['gatewayFixedAmount']) ? mysqli_real_escape_string($conn, $data['gatewayFixedAmount']) : null;
    $gatewayPercentage = isset($data['gatewayPercentage']) ? mysqli_real_escape_string($conn, $data['gatewayPercentage']) : null;
    $facebook = isset($data['facebook']) ? mysqli_real_escape_string($conn, $data['facebook']) : null;
    $twitter = isset($data['twitter']) ? mysqli_real_escape_string($conn, $data['twitter']) : null;
    $youtube = isset($data['youtube']) ? mysqli_real_escape_string($conn, $data['youtube']) : null;
    $instagram = isset($data['instagram']) ? mysqli_real_escape_string($conn, $data['instagram']) : null;
    $linkedin = isset($data['linkedin']) ? mysqli_real_escape_string($conn, $data['linkedin']) : null;
    $website = isset($data['website']) ? mysqli_real_escape_string($conn, $data['website']) : null;
    $currency = isset($data['currency']) ? mysqli_real_escape_string($conn, $data['currency']) : null;
    $tutorial = isset($data['tutorial']) ? mysqli_real_escape_string($conn, $data['tutorial']) : null;


    $adminId = isset($data['adminId']) ? mysqli_real_escape_string($conn, $data['adminId']) : null;


    $updateQuery = "UPDATE system_setting SET 
    `cname` = '$companyName',
    `address1` = '$address1',
    `address2` = '$address2',
    `tel` = '$phone',
    `def_reg_fee` = '$defaultregfee',
    `def_senderid_fee` = '$defaultsenderidfee',
    `account_name` = '$accountName',
    `bank_name` = '$bankName',
    `account_no` = '$accountNo',
    `branch` = '$branch',
    `swift_code` = '$swiftCode',
    `merchant_id` = '$merchantId',
    `mech_secretkey` = '$merchantSecretKey',
    `gateway_fixed` = '$gatewayFixedAmount',
    `gateway_presentage` = '$gatewayPercentage',
    `facebook` = '$facebook',
    `twitter` = '$twitter',
    `youtube` = '$youtube',
    `instra` = '$instagram',
    `linkedin` = '$linkedin',
    `webname` = '$website',
    `currency` = '$currency',
    `senderid_tutorial` = '$tutorial'
        ";

    
    $updateResult = mysqli_query($conn, $updateQuery);

    if ($updateResult) {
        $response = array('success' => true, 'message' => 'system setting company details updated successfully');
        $by = $userId;
        $date = date('Y-m-d H:i:s');
        $module = 'update system setting company details';
        $message = "Administrator $userId has successfully updated the system setting company details.";

        insertAdminLog($conn, $by, $date, $module, $message);
    } else {
        $response = array('success' => false, 'message' => 'Failed to update promo and trans cost');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}

?>