<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include ("include/connection.php");
include ("adminlogs/admin_logs.php");

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $trans_per_msg = isset($data['trans_per_msg']) ? mysqli_real_escape_string($conn, $data['trans_per_msg']) : null;
    $promo_per_msg = isset($data['promo_per_msg']) ? mysqli_real_escape_string($conn, $data['promo_per_msg']) : null;
    $set_up_fee = isset($data['set_up_fee']) ? mysqli_real_escape_string($conn, $data['set_up_fee']) : null;
    $sender_id_fee = isset($data['sender_id_fee']) ? mysqli_real_escape_string($conn, $data['sender_id_fee']) : null;
    $id = isset($data['id']) ? mysqli_real_escape_string($conn, $data['id']) : null;
    $name = isset($data['name']) ? mysqli_real_escape_string($conn, $data['name']) : null;
    $adminId = isset($data['adminId']) ? mysqli_real_escape_string($conn, $data['adminId']) : null;


    $updateQuery = "UPDATE packages SET 
    `trans_per_msg` = '$trans_per_msg',
    `promo_per_msg` = '$promo_per_msg',
    `set_up_fee` = '$set_up_fee',
    `sender_id_fee` = '$sender_id_fee',
    `name` = '$name'
    WHERE `id` = '$id'
    ";

    // echo $updateQuery;

    $updateResult = mysqli_query($conn, $updateQuery);

    if ($updateResult) {
        $response = array('success' => true, 'message' => "Package (ID: $id) information updated successfully.");
        
        $by = $adminId;
        $date = date('Y-m-d H:i:s');
        $module = 'update package';
        $message = "Administrator $adminId has successfully updated the announce section.";

        insertAdminLog($conn, $by, $date, $module, $message);
    } else {
        $response = array('success' => false, 'message' => 'Failed to update email service');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}

?>