<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");
include("adminlogs/admin_logs.php");

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $admin = isset($data['admin']) ? mysqli_real_escape_string($conn, $data['admin']) : null;
    $client = isset($data['client']) ? mysqli_real_escape_string($conn, $data['client']) : null;
    $api = isset($data['api']) ? mysqli_real_escape_string($conn, $data['api']) : null;
    $adminId = isset($data['adminId']) ? mysqli_real_escape_string($conn, $data['adminId']) : null;


    $updateQuery = "UPDATE system_setting SET 
    `admin_mod` = '$admin',
    `client_mod` = '$client',
    `api_mod` = '$api'
    ";

    // echo $updateQuery;

    $updateResult = mysqli_query($conn, $updateQuery);

    if ($updateResult) {
        $response = array('success' => true, 'client' => 'Maintenance service updated successfully');
        $by = $adminId;
        $date = date('Y-m-d H:i:s');
        $module = 'update Maintenance';
        $message = "Administrator $adminId has successfully updated the Maintenance section.";

        insertAdminLog($conn, $by, $date, $module, $message);
    } else {
        $response = array('success' => false, 'message' => 'Failed to update email service');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}

?>