<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include ("include/connection.php");
include ("adminlogs/admin_logs.php");
include ("notification/client_notification.php");
include ("jwtvalidation/jwt_validation.php");
require 'secret_key.php';

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $id = isset($data['id']) ? mysqli_real_escape_string($conn, $data['id']) : '';
    $transCost = isset($data['transCost']) ? mysqli_real_escape_string($conn, $data['transCost']) : '';
    $promCost = isset($data['promCost']) ? mysqli_real_escape_string($conn, $data['promCost']) : '';
    $msgLength = isset($data['msgLength']) ? mysqli_real_escape_string($conn, $data['msgLength']) : '';
    $note = isset($data['note']) ? mysqli_real_escape_string($conn, $data['note']) : '';


    // Update trans_per_msg and promocost in clients table
    $updateClientQuery = "UPDATE gateway SET  `t_cost` = '$transCost', `p_cost` = '$promCost', `opt_out_lenght` = '$msgLength', `note` = '$note' WHERE `id` = '$id'";
    $updateClientResult = mysqli_query($conn, $updateClientQuery);


    if ($updateClientResult) {
        $response = array('success' => true, 'message' => 'promo and trans cost updated successfully');

        // admin login
        $by = $userId;
        $date = date('Y-m-d H:i:s');
        $module = 'update Route';
        $message = "Administrator $userId has successfully updated the route";

        insertAdminLog($conn, $by, $date, $module, $message);

    } else {
        $response = array('success' => false, 'message' => 'Failed to update promo and trans cost');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}

?>