<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");
include("adminlogs/admin_logs.php");
include("jwtvalidation/jwt_validation.php");
require 'secret_key.php';

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

     // Validate the JWT token
     $headers = apache_request_headers();
     $secretKey = $secret_Key;
     $decodedToken = validateJWT($headers, $secretKey);

     $userId = $decodedToken['user_id'];

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $clientid = isset($data['clientid']) ? mysqli_real_escape_string($conn, $data['clientid']) : null;
    $venderid = isset($data['venderid']) ? mysqli_real_escape_string($conn, $data['venderid']) : null;
    $apikey = isset($data['apikey']) ? mysqli_real_escape_string($conn, $data['apikey']) : null;
    $venderemail = isset($data['venderemail']) ? mysqli_real_escape_string($conn, $data['venderemail']) : null;
    $generalemail = isset($data['generalemail']) ? mysqli_real_escape_string($conn, $data['generalemail']) : null;
    $venderheader = isset($data['venderheader']) ? mysqli_real_escape_string($conn, $data['venderheader']) : null;

    $adminId = isset($data['adminId']) ? mysqli_real_escape_string($conn, $data['adminId']) : null;


    $updateQuery = "UPDATE system_setting SET 
    `email_api_client_id` = '$clientid',
    `email_api_vend_id` = '$venderid',
    `email_api_key` = '$apikey',
    `email_api_vender_email` = '$venderemail',
    `email_api_vender_header` = '$venderheader',
    `email` = '$generalemail'
        ";

    
    $updateResult = mysqli_query($conn, $updateQuery);

    if ($updateResult) {
        $response = array('success' => true, 'message' => 'email service updated successfully');
        $by = $userId;
        $date = date('Y-m-d H:i:s');
        $module = 'update email service';
        $message = "Administrator $userId has successfully updated the email service.";

        insertAdminLog($conn, $by, $date, $module, $message);
    } else {
        $response = array('success' => false, 'message' => 'Failed to update email service');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}

?>