<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include ("include/connection.php");
include ("jwtvalidation/jwt_validation.php");
require 'secret_key.php';

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    // $headers = apache_request_headers();
    // $secretKey = $secret_Key;
    // $decodedToken = validateJWT($headers, $secretKey);

    // $userId = $decodedToken['user_id'];

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);


    $technical_totalCount = 0;
    $billing_totalCount = 0;
    $sales_totalCount = 0;

    $count_query = "SELECT COUNT(*) as technical_total FROM ticket_header WHERE department='technical' AND admin_status = 'unread'";

    $count_result = mysqli_query($conn, $count_query);

    if ($count_result) {
        $technical_totalCount = mysqli_fetch_assoc($count_result)['technical_total'];
        $technical_totalCount = intval($technical_totalCount);
    }
    // .........................................................................................................

    $billing_query = "SELECT COUNT(*) as billing_total FROM ticket_header WHERE department='billing' AND admin_status = 'unread'";

    $billing_result = mysqli_query($conn, $billing_query);

    if ($billing_result) {
        $billing_totalCount = mysqli_fetch_assoc($billing_result)['billing_total'];
        $billing_totalCount = intval($billing_totalCount);
    }

    //................................................................

    

    $sales_query = "SELECT COUNT(*) as sales_total FROM ticket_header WHERE department='sales' AND admin_status = 'unread'";

    $sales_result = mysqli_query($conn, $sales_query);

    if ($sales_result) {
        $sales_totalCount = mysqli_fetch_assoc($sales_result)['sales_total'];
        $sales_totalCount = intval($sales_totalCount);
    }



    if (!empty($count_result && $billing_result && $sales_result )) {
        $response = array('success' => true, 'technical_total' => $technical_totalCount, 'billing_total' => $billing_totalCount, 'sales_total' => $sales_totalCount,   'message' => 'Authentication successful');

    } else {
        $response = array('success' => false, 'message' => 'invalid logs');

    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}

?>