<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/x-www-form-urlencoded; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include ("include/connection.php");
include ("adminlogs/admin_logs.php");

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $id = isset($data['id']) ? mysqli_real_escape_string($conn, $data['id']) : null;
    $adminId = isset($data['adminId']) ? mysqli_real_escape_string($conn, $data['adminId']) : null;

    // Select the current balance
    $selectQuery = "UPDATE ticket_header SET admin_status = 'read' WHERE `id` = '$id'";
    $selectResult = mysqli_query($conn, $selectQuery);

    if ($selectResult) {
        $response = array('success' => true, 'message' => 'Balance updated successfully');

        $by = $adminId;
        $date = date('Y-m-d H:i:s');
        $module = 'Ticket View';
        $message = "Administrator $adminId has been viewed the Ticket $id.";

        insertAdminLog($conn, $by, $date, $module, $message);


    } else {
        $response = array('success' => false, 'message' => 'Failed to update balance');
    }

    echo json_encode($response);


} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}

?>