<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/x-www-form-urlencoded; charset=utf-8'); 
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");

try {

    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
        
    }

    $merchant_id         = $_POST['merchant_id'];
    $order_id            = $_POST['order_id'];
    $payhere_amount      = $_POST['payhere_amount'];
    $payhere_currency    = $_POST['payhere_currency'];
    $status_code         = $_POST['status_code'];
    $md5sig              = $_POST['md5sig'];

    $merchant_secret = ''; 

    $query = "SELECT * FROM system_setting";

    $result = mysqli_query($conn, $query);

    if (!$result) {
        throw new Exception('Failed to check current password');
    }

    // $merchant_secret='MjE0MTY5MzkxNzE0NDY5OTQ5MTIyMjIxMTc3OTQxMjczNjg0MjQ5MA==';

    $row = mysqli_fetch_assoc($result);

    $merchant_secret = $row['mech_secretkey_admin'];


    // Calculate local MD5 signature
    $local_md5sig = strtoupper(
        string: md5(
            $merchant_id . 
            $order_id . 
            $payhere_amount . 
            $payhere_currency . 
            $status_code . 
            strtoupper(md5($merchant_secret)) 
        ) 
    );

    if (($local_md5sig === $md5sig) and ($status_code == 2)) {
        // TODO: Update your database as payment success
        $query = "INSERT INTO `test_payhere` (`message`) VALUES ('halo')";
        $result = mysqli_query($conn, $query);

        if (!$result) {
            throw new Exception('Database error: ' . mysqli_error($conn));
        }
    }
} catch (Exception $e) {
    // Handle exceptions, log errors, etc.
    echo json_encode(['error' => $e->getMessage()]);
}

?>
