<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $order_id = isset($data['order_id']) ? mysqli_real_escape_string($conn, $data['order_id']) : null;
    $amount = isset($data['amount']) ? mysqli_real_escape_string($conn, $data['amount']) : null;
    $currency = isset($data['currency']) ? mysqli_real_escape_string($conn, $data['currency']) : null;

    $merchant_secret = '';
    $merchant_id = '';
    $invoice_data = '';

    // get invoice and client data
    $invoice_query = "SELECT invoice_HID,`description`,client_id FROM invoice_details WHERE `invoice_HID` = $order_id";

    $invice_result = mysqli_query($conn, $invoice_query);

    if (!$invice_result) {
        throw new Exception('query failed');
    }

    $invoice_data = mysqli_fetch_assoc($invice_result);

    $client_id = $invoice_data['client_id'];

    $client_query = "SELECT f_name,l_name,email,mobile,bill_address FROM `clients` WHERE `c_id` = $client_id";

    $client_result = mysqli_query($conn, $client_query);

    $client_row_count = mysqli_num_rows($client_result);

    if ($client_row_count == 1) {

        $client_row = mysqli_fetch_assoc($client_result);

        $client_data = $client_row;

        $invoice_data['client_details'] = $client_data;

    }


    // get the data from system setting

    $query = "SELECT * FROM system_setting";

    $result = mysqli_query($conn, $query);

    if (!$result) {
        throw new Exception('Failed to check current password');
    }

    $row = mysqli_fetch_assoc($result);

    $merchant_secret = $row['mech_secretkey_admin'];
    $merchant_id = $row['merchant_id_admin'];
    $precentage = $row['gateway_presentage'];
    $fixed_amount = $row['gateway_fixed'];
    $total = $amount + ($amount * $precentage) / 100 + $fixed_amount;

    $total = (string) $total;

    $hash = strtoupper(
        md5(
            $merchant_id .
            $order_id .
            number_format($total, 2, '.', '') .
            $currency .
            strtoupper(md5($merchant_secret))
        )
    );

    $pay_details = array();

    $pay_details['hash'] = $hash;
    $pay_details['merchant_id'] = $merchant_id;
    $pay_details['invoice_data'] = $invoice_data;
    $pay_details['total'] = $total;

    if (!empty($hash)) {
        $response = array('success' => true, 'pay' => $pay_details, 'message' => 'hash code');
    } else {
        $response = array('success' => false, 'message' => 'error creating hash');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}

?>