<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include ("include/connection.php");

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $teacherIds = [10, 15, 17];
    $teacherDataArray = array();

    // Function to retrieve data for each teacher and save it to the array
    function fetchDataForTeacher($conn, $teacherId)
    {
        $query = "SELECT * FROM clients WHERE `status` = 1 AND `verification_status` = 1 AND c_id = '$teacherId'";

        $result = mysqli_query($conn, $query);

        if ($result) {
            $row = mysqli_fetch_assoc($result);
            return $row;
        }

        return null;
    }

    // Fetch data for each teacher
    foreach ($teacherIds as $teacherId) {
        $teacherData = fetchDataForTeacher($conn, $teacherId);
        if ($teacherData) {
            $teacherDataArray[] = $teacherData;
        }
    }

    // Close the database connection
    mysqli_close($conn);

    // Convert the array to JSON and echo it
    echo json_encode($teacherDataArray);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
?>
