<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include ("include/connection.php");
include ("jwtvalidation/jwt_validation.php");
require 'secret_key.php';

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];

    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    // get all row count
    $page = isset($data['page']) ? intval($data['page']) : 0;
    $pageSize = isset($data['pageSize']) ? intval($data['pageSize']) : 10;

    // Calculate offset for pagination
    $offset = ($page) * $pageSize;

    // Prepare statement for counting total records
    $countQuery = "SELECT COUNT(*) as total FROM logs";
    $countStatement = mysqli_prepare($conn, $countQuery);
    mysqli_stmt_execute($countStatement);
    mysqli_stmt_bind_result($countStatement, $row_totalCount);
    mysqli_stmt_fetch($countStatement);
    mysqli_stmt_close($countStatement);

    // Prepare statement for fetching logs with pagination
    $query = "SELECT * FROM logs ORDER BY `clog_id` DESC LIMIT ?, ?";
    $statement = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($statement, "ii", $offset, $pageSize);
    mysqli_stmt_execute($statement);
    $result = mysqli_stmt_get_result($statement);

    // Array to store fetched data
    $smslog_data = array();

    // Fetch logs and client details
    while ($row = mysqli_fetch_assoc($result)) {
        $client_id = $row['client_id'];

        $serverResponse = json_decode($row["serverResponse"]);

        if (is_object($serverResponse)) {
            $row["serverResponse"] = $serverResponse;
        }

        // Prepare statement for fetching client details
        $client_query = "SELECT f_name, l_name, c_id, mobile, company_name FROM clients WHERE c_id = ?";
        $client_statement = mysqli_prepare($conn, $client_query);
        mysqli_stmt_bind_param($client_statement, "i", $client_id);
        mysqli_stmt_execute($client_statement);
        $client_result = mysqli_stmt_get_result($client_statement);

        // Fetch client details
        if ($client_row = mysqli_fetch_assoc($client_result)) {
            $row['client_details'] = $client_row;
            $smslog_data[] = $row;
        }

        mysqli_stmt_close($client_statement);
    }

    // Close statement
    mysqli_stmt_close($statement);

    if (!empty($smslog_data)) {
        $response = array('success' => true, 'smslog' => $smslog_data, 'total' => $row_totalCount, 'message' => 'All the client details with sender data');
    } else {
        $response = array('success' => false, 'message' => 'No clients found');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}

?>