<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require 'include/connection.php';
include("systemlogs/system_logs.php");



// send_sms function in PHP - cURL
function send_sms($client_id, $api_key, $sender_id, $message, $recipient_contact_no)
{

    // curl post

    $curl = curl_init();

    curl_setopt($curl, CURLOPT_URL, "https://cp.sparksender.com/api/send/?");
    curl_setopt($curl, CURLOPT_POST, 1);
    curl_setopt(
        $curl,
        CURLOPT_POSTFIELDS,
        "user_id={$client_id}&api_key={$api_key}&sender_id={$sender_id}&message={$message}&recipient_contact_no={$recipient_contact_no}"
    );

    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($curl);

    curl_close($curl);

    return $response;

}

try {
    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $id = isset($data['id']) ? mysqli_real_escape_string($conn, $data['id']) : null;
    $invoiceno = isset($data['invoiceno']) ? mysqli_real_escape_string($conn, $data['invoiceno']) : null;
    $adminId = isset($data['adminId']) ? intval($data['adminId']) : 0;


    // get client email
    $query = "SELECT * FROM clients WHERE c_id = '$id'";

    $result = mysqli_query($conn, $query);

    if (!$result) {
        throw new Exception(mysqli_error($conn));
    }

    $row = mysqli_fetch_assoc($result);

    $phone = $row["mobile"];

    // get invoice details
    $query_invoice = "SELECT * FROM invoice_details WHERE invoice_HID = '$invoiceno'";

    $result_invoice = mysqli_query($conn, $query_invoice);

    if (!$result_invoice) {
        throw new Exception(mysqli_error($conn));
    }

    if ($result_invoice) {
        $row_invoice = mysqli_fetch_assoc($result_invoice);

        $total = $row_invoice['total'];
        $date = $row_invoice['date'];

        //set variables
        $client_id = "103";
        $api_key = "103TKEUog4WVyrvDz0";
        $sender_id = "oZoneSender";
        $message = "Dear customer, this is a friendly reminder to settle the outstanding balance of Rs $total for Invoice $invoiceno.Call 0705289928 for more details";
        $recipient_contact_no = $phone;

        // call send_sms function

        $sms_details = send_sms($client_id, $api_key, $sender_id, $message, $recipient_contact_no);

        $sms_details_array = json_decode($sms_details, true);

        // Extract status_code and msg_id
        $status_code = $sms_details_array['status_code'];
        $msg_id = $sms_details_array['msg_id'];

        //   systemlogs
        $client = $id;
        $date = date('Y-m-d H:i:s');
        $module = "Invoice sms reminder";
        $message = "Admin $adminId - Status Code: $status_code, Message ID: $msg_id";

        insertSystemLog($conn, $client, $date, $module, $message);
        $response = array('success' => true, 'message' => 'Data inserted successfully' , 'status_code' => $status_code);


    } else {
        $response = array('success' => false, 'message' => 'Failed to insert data');
    }


    echo json_encode($response);


} catch (\Throwable $th) {
    $response = array(
        'error' => true,
        'message' => 'An unexpected error occurred.',
        'details' => $th->getMessage()
    );
    echo json_encode($response);
}


?>