<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");
include("jwtvalidation/jwt_validation.php");
require 'secret_key.php';

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
        throw new Exception('Invalid request method');
    }

    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];

    $json_data = file_get_contents('php://input');

    // Sanitize and decode the JSON data
    $data = json_decode($json_data, true);

    // Initialize variables
    $three_senderid_totalCount = 0;
    $seven_senderid_totalCount = 0;
    $fourteen_senderid_totalCount = 0;
    $thirty_senderid_totalCount = 0;
    $sixty_senderid_totalCount = 0;
    $ninty_senderid_totalCount = 0;
    $row_totalCount = 0;


    // Function to execute count query
    function executeCountQuery($conn, $daysAgo, $yesterday)
    {
        $query = "SELECT COUNT(*) as 'total' FROM sender_details WHERE Date(`date`) BETWEEN '$daysAgo' AND '$yesterday'";

        $result = mysqli_query($conn, $query);
        return $result ? intval(mysqli_fetch_assoc($result)['total']) : 0;
    }

    // Calculate dates
    $yesterday = date('Y-m-d', strtotime('-1 day'));
    $threeDaysAgo = date('Y-m-d', strtotime('-3 days'));
    $sevenDaysAgo = date('Y-m-d', strtotime('-7 days'));
    $fourteenDaysAgo = date('Y-m-d', strtotime('-14 days'));
    $thirtyDaysAgo = date('Y-m-d', strtotime('-30 days'));
    $sixtyDaysAgo = date('Y-m-d', strtotime('-60 days'));
    $nintyDaysAgo = date('Y-m-d', strtotime('-90 days'));

    // Execute count queries
    $three_senderid_totalCount = executeCountQuery($conn, $threeDaysAgo, $yesterday);
    $seven_senderid_totalCount = executeCountQuery($conn, $sevenDaysAgo, $yesterday);
    $fourteen_senderid_totalCount = executeCountQuery($conn, $fourteenDaysAgo, $yesterday);
    $thirty_senderid_totalCount = executeCountQuery($conn, $thirtyDaysAgo, $yesterday);
    $sixty_senderid_totalCount = executeCountQuery($conn, $sixtyDaysAgo, $yesterday);
    $ninty_senderid_totalCount = executeCountQuery($conn, $nintyDaysAgo, $yesterday);

    // All sender IDs
    $query = "SELECT COUNT(*) as 'total' FROM sender_details"; 

    $result = mysqli_query($conn, $query);

    if ($result) {
        $row_totalCount = mysqli_fetch_assoc($result)['total'];
        $row_totalCount = intval($row_totalCount);
    } else {
        $row_totalCount = 0;
    }
  

    // Response
    echo json_encode(array('success' => true, 'threedayssenderid' => $three_senderid_totalCount, 'sevendayssenderid' => $seven_senderid_totalCount, 'fourteendayssenderid' => $fourteen_senderid_totalCount, 'thirtydayssenderid' => $thirty_senderid_totalCount, 'sixtydayssenderid' => $sixty_senderid_totalCount, 'nintydayssenderid' => $ninty_senderid_totalCount, 'alldayssenderid' => $row_totalCount));
} catch (\Throwable $th) {
    echo json_encode(array('success' => false, 'message' => $th->getMessage()));
}
?>
