<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include ("include/connection.php");
include("jwtvalidation/jwt_validation.php");
require 'secret_key.php';

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    // $headers = apache_request_headers();
    // $secretKey = $secret_Key;
    // $decodedToken = validateJWT($headers, $secretKey);

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $startDate = isset ($data['startdate']) ? $data['startdate'] : null;
    $endDate = isset ($data['enddate']) ? $data['enddate'] : null;
    $value = isset ($data['value']) ? $data['value'] : null;
    $sender_id = isset ($data['sender_id']) ? mysqli_real_escape_string($conn, $data['sender_id']) : null;
    $pClints = isset ($data['pClints'])? mysqli_real_escape_string($conn, $data['pClints']) : null;
    $page = isset ($data['page']) ? intval($data['page']) : 0;
    $pageSize = isset ($data['pageSize']) ? intval($data['pageSize']) : 10;

    $client_data = array();

    $offset = ($page) * $pageSize;

    if ($sender_id !== '') {
        // ....................................
        $count_query = "SELECT COUNT(*) as total  FROM clients
        INNER JOIN sender_details ON clients.c_id = sender_details.client_id
        WHERE sender_details.status = 'Active' AND sender_details.adminStatus = 'approved' AND sender_details.sender_id = '$sender_id' AND clients.status = 1";

        if ($startDate !== null && $endDate !== null) {
             $startDate .= ' 00:00:00';
        $endDate .= ' 23:59:59';
            $count_query .= " AND register_date BETWEEN '$startDate' AND '$endDate'";
        }

        if ($value !== null && $value !== '') {
            $count_query .= " AND (c_id = '$value' OR mobile = '$value' OR email = '$value' OR company_name LIKE '%$value%' OR f_name = '$value')";
        }

        if($pClints != '' && $pClints != null){
            $count_query.= " AND clients.productive_cli = '$pClints'";
        }

        $count_result = mysqli_query($conn, $count_query);

        if ($count_result) {
            $row_totalCount = mysqli_fetch_assoc($count_result)['total'];
            $row_totalCount = intval($row_totalCount);
        }

        // ........................................................................................................

        // Fetch clients based on sender_id
        $clients_query = "SELECT clients.* FROM clients
        INNER JOIN sender_details ON clients.c_id = sender_details.client_id
        WHERE sender_details.status = 'Active' AND sender_details.adminStatus = 'approved' AND sender_details.sender_id = '$sender_id' AND clients.status = 1";

        if ($startDate !== null && $endDate !== null) {
             $startDate .= ' 00:00:00';
        $endDate .= ' 23:59:59';
            $clients_query .= " AND clients.register_date BETWEEN '$startDate' AND '$endDate'";
        }

        if ($value !== null && $value !== '') {
            $clients_query .= " AND (clients.c_id = '$value' OR clients.mobile = '$value' OR clients.email = '$value' OR company_name LIKE '%$value%' OR f_name = '$value')";
        }

        if($pClints != '' && $pClints != null){
            $clients_query.= " AND clients.productive_cli = '$pClints'";
        }


        $clients_query .= "  ORDER BY `c_id` DESC";

        $clients_query .= " LIMIT $offset, $pageSize";

        $clients_result = mysqli_query($conn, $clients_query);

        if (!$clients_result) {
            throw new Exception('Error executing the query');
        }


        while ($client_row = mysqli_fetch_assoc($clients_result)) {
            $client_id = $client_row['c_id'];

            // Fetch sender data for each client
            $sender_query = "SELECT sender_id,s_id,`type` FROM sender_details WHERE client_id = $client_id AND status = 'Active' AND adminStatus = 'approved' AND `sender_id` = '$sender_id' ";

            $sender_result = mysqli_query($conn, $sender_query);

            $sender_data = array();

            while ($sender_row = mysqli_fetch_assoc($sender_result)) {
                $sender_data[] = $sender_row;
            }

            // Combine client and sender data into one array
            $client_row['sender_data'] = $sender_data;
            $client_data[] = $client_row;
        }

    } else {
        // .......................................................................
        $count_query = "SELECT COUNT(*) as total  FROM clients WHERE status = 1 AND `verification_status` = 1";

        if ($startDate !== null && $endDate !== null) {
             $startDate .= ' 00:00:00';
        $endDate .= ' 23:59:59';
            $count_query .= " AND register_date BETWEEN '$startDate' AND '$endDate'";
        }

        if ($value !== null && $value !== '') {
            $count_query .= " AND (c_id = '$value' OR mobile = '$value' OR email = '$value' OR company_name LIKE '%$value%' OR f_name = '$value')";
        }

        if($pClints != '' && $pClints != null){
            $count_query.= " AND clients.productive_cli = '$pClints'";
        }


        $count_result = mysqli_query($conn, $count_query);

        if ($count_result) {
            $row_totalCount = mysqli_fetch_assoc($count_result)['total'];
            $row_totalCount = intval($row_totalCount);
        }
        // .........................................................................................................
        $clients_query = "SELECT * FROM clients WHERE status = 1 AND `verification_status` = 1";

        if ($startDate !== null && $endDate !== null) {
             $startDate .= ' 00:00:00';
        $endDate .= ' 23:59:59';
            $clients_query .= " AND register_date BETWEEN '$startDate' AND '$endDate'";
        }

        if ($value !== null && $value !== '') {
            $clients_query .= " AND (c_id = '$value' OR mobile = '$value' OR email = '$value' OR company_name LIKE '%$value%' OR f_name = '$value')";
        }

        if($pClints != '' && $pClints != null){
            $clients_query.= " AND clients.productive_cli = '$pClints'";
        }

        $clients_query .= "  ORDER BY `c_id` DESC";

        $clients_query .= " LIMIT $offset, $pageSize";

        $clients_result = mysqli_query($conn, $clients_query);

        if (!$clients_result) {
            throw new Exception('Error executing the query');
        }

        while ($client_row = mysqli_fetch_assoc($clients_result)) {
            $client_id = $client_row['c_id'];

            // Fetch sender data for each client
            $sender_query = "SELECT sender_id,s_id,`type` FROM sender_details WHERE client_id = $client_id AND status = 'Active' AND adminStatus = 'approved'";

            $sender_result = mysqli_query($conn, $sender_query);

            $sender_data = array();

            while ($sender_row = mysqli_fetch_assoc($sender_result)) {
                $sender_data[] = $sender_row;
            }

            // Combine client and sender data into one array
            $client_row['sender_data'] = $sender_data;
            $client_data[] = $client_row;
        }
    }



    if (!empty ($client_data)) {
        $response = array('success' => true, 'client' => $client_data, 'total' => $row_totalCount,'message' => 'invoice found within the date range');
    } else {
        $response = array('success' => false, 'message' => 'No invoice found within the date range');
    }

    echo json_encode($response);

    // Close the database connection
    mysqli_close($conn);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
?>