<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");
include("jwtvalidation/jwt_validation.php");
require 'secret_key.php';

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $startDate = isset($data['startdate']) ? mysqli_real_escape_string($conn, $data['startdate']) : null;
    $endDate = isset($data['enddate']) ? mysqli_real_escape_string($conn, $data['enddate']) : null;
    $c_id = isset($data['c_id']) ? mysqli_real_escape_string($conn, $data['c_id']) : null;


    $topup_data = array();

    $query = "SELECT * FROM topup_history WHERE 1=1";

    if ($startDate !== null && $endDate !== null) {
        $startDate .= ' 00:00:00';
        $endDate .= ' 23:59:59';
        $query .= " AND `datetime` BETWEEN '$startDate' AND '$endDate'";
    }

    if ($c_id !== null && $c_id !== '') {
        $query .= " AND `user_id` = '$c_id'";
    }
    
    $query .= "  ORDER BY `id` DESC";

    $result = mysqli_query($conn, $query);

    $row_count = mysqli_num_rows($result);

    if ($row_count > 0) {

        while ($row = mysqli_fetch_assoc($result)) {
            $client_id = $row['user_id'];

            $client_query = "SELECT f_name,l_name,email,mobile,company_name FROM `clients` WHERE `c_id` = $client_id";

            $client_result = mysqli_query($conn, $client_query);

            $client_row_count = mysqli_num_rows($client_result);

            if ($client_row_count == 1) {

                $client_data = mysqli_fetch_assoc($client_result);

                $row['client_details'] = $client_data;
                $topup_data[] = $row;
            }
        }

        $response = array('success' => true, 'topup' => $topup_data, 'message' => 'All the client details with sender data');
    } else {
        $response = array('success' => false, 'message' => 'No clients found');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
?>