<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include ("include/connection.php");
include ("jwtvalidation/jwt_validation.php");
require 'secret_key.php';

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $startDate = isset($data['startdate']) ? mysqli_real_escape_string($conn, $data['startdate']) : null;
    $endDate = isset($data['enddate']) ? mysqli_real_escape_string($conn, $data['enddate']) : null;
    $c_id = isset($data['c_id']) ? mysqli_real_escape_string($conn, $data['c_id']) : null;
    $role = isset($data['role']) ? mysqli_real_escape_string($conn, $data['role']) : null;
    $status = isset($data['status']) ? mysqli_real_escape_string($conn, $data['status']) : null;
    $value = isset($data['value']) ? mysqli_real_escape_string($conn, $data['value']) : null;
    $requestType = isset($data['requestType']) ? mysqli_real_escape_string($conn, $data['requestType']) : null;
    $page = isset($data['page']) ? intval($data['page']) : 0;
    $pageSize = isset($data['pageSize']) ? intval($data['pageSize']) : 10;

    $smslog_data = array();
    $row_totalCount = 0;

    $offset = ($page) * $pageSize;

    $countQuery = "SELECT SQL_CALC_FOUND_ROWS * FROM logs WHERE 1=1";

    if ($startDate !== null && $endDate !== null) {
        $startDate .= ' 00:00:00';
        $endDate .= ' 23:59:59';
        $countQuery .= " AND `create_date` BETWEEN '$startDate' AND '$endDate'";
    }

    if ($role !== null && $role !== '') {
        $countQuery .= " AND `sender_id` = '$role'";
    }

    if ($value !== null && $value !== '') {
        $countQuery .= " AND `send_to` LIKE '%$value%'";
    }

    if ($status !== null && $status !== '') {
        $countQuery .= " AND `g_deliveryStatus` = '$status'  AND `status` = '1'";
    }

    if ($requestType !== null && $requestType !== '') {
        $countQuery .= " AND `type` = '$requestType'";
    }

    if ($c_id !== null && $c_id !== '') {
        $countQuery .= " AND `client_id` = '$c_id'";
    }


    $query = "$countQuery ORDER BY `clog_id` DESC LIMIT $pageSize OFFSET $offset";

    $result = mysqli_query($conn, $query);
    $row_count = mysqli_num_rows($result);

    $countResult = mysqli_query($conn, "SELECT FOUND_ROWS() as total");
    $row_totalCount = mysqli_fetch_assoc($countResult)['total'];

    $row_totalCount = intval($row_totalCount);

    if ($row_count > 0) {

        while ($row = mysqli_fetch_assoc($result)) {
            $client_id = $row['client_id'];

            $serverResponse = json_decode($row["serverResponse"]);


            if (is_object($serverResponse)) {
                $row["serverResponse"] = $serverResponse;
            }

            $client_query = "SELECT f_name, l_name, c_id, mobile, company_name FROM clients WHERE c_id = ?";
            $client_statement = mysqli_prepare($conn, $client_query);
            mysqli_stmt_bind_param($client_statement, "i", $client_id);
            mysqli_stmt_execute($client_statement);
            $client_result = mysqli_stmt_get_result($client_statement);

            // Fetch client details
            if ($client_row = mysqli_fetch_assoc($client_result)) {
                $row['client_details'] = $client_row;
                $smslog_data[] = $row;
            }

        }

    }


    if (!empty($smslog_data)) {
        $response = array('success' => true, 'smslog' => $smslog_data, 'total' => $row_totalCount, 'message' => 'All the client details with sender data');
    } else {
        $response = array('success' => false, 'message' => 'No clients found within the date range');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
?>