<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $senderid = isset($data['senderid']) ? mysqli_real_escape_string($conn, $data['senderid']) : null;
    

    $sender_data = array();

    $query = "SELECT * FROM sender_details WHERE adminStatus = 'processing' AND nocApprovel = 'processing' AND submittonoc = 1";

    if ($senderid !== null && $senderid !== '') {
        $query .= " AND `sender_id` LIKE '%$senderid%'";
    }

    $result = mysqli_query($conn, $query);

    $row_count = mysqli_num_rows($result);

    if ($row_count > 0) {

        while ($row = mysqli_fetch_assoc($result)) {
            $sender_data[] = $row;
        }

    }


    if (!empty($sender_data)) {
        $response = array('success' => true, 'sender' => $sender_data, 'message' => 'All the client details with sender data');
    } else {
        $response = array('success' => false, 'message' => 'No clients found within the date range');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
?>