<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include ("include/connection.php");
include ("jwtvalidation/jwt_validation.php");
require 'secret_key.php';

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $c_id = isset($data['c_id']) ? mysqli_real_escape_string($conn, $data['c_id']) : null;
    $status = isset($data['status']) ? mysqli_real_escape_string($conn, $data['status']) : null;
    $groupName = isset($data['groupName']) ? mysqli_real_escape_string($conn, $data['groupName']) : null;
    $page = isset($data['page']) ? intval($data['page']) : 0;
    $pageSize = isset($data['pageSize']) ? intval($data['pageSize']) : 10;

    $contact_data = array();
    $allcontact_data = array();

    $row_totalCount = 0;

    $offset = ($page) * $pageSize;

    $group_query = "SELECT * FROM `groups` WHERE 1=1";

    $group_result = mysqli_query($conn, $group_query);

    if ($group_result) {
        while ($row = mysqli_fetch_assoc($group_result)) {
            $allcontact_data[] = $row;
        }
    }

    // ................................................
    $count_query = "SELECT COUNT(*) as total FROM `groups` WHERE 1=1 ";

    if ($groupName !== null && $groupName !== '') {
        $count_query .= " AND  g_id = '$groupName'";
    }

    if ($status !== null && $status !== '') {
        $count_query .= " AND `status` = '$status'";
    }

    if ($c_id !== null && $c_id !== '') {
        $count_query .= " AND `client_id` = '$c_id'";
    }

    $count_result = mysqli_query($conn, $count_query);

    if ($count_result) {
        $row_totalCount = mysqli_fetch_assoc($count_result)['total'];
        $row_totalCount = intval($row_totalCount);
    }
    //.......................................... 

    $query = "SELECT * FROM `groups` WHERE 1=1";

    if ($groupName !== null && $groupName !== '') {
        $query .= " AND  g_id = '$groupName'";
    }

    if ($status !== null && $status !== '') {
        $query .= " AND `status` = '$status'";
    }

    if ($c_id !== null && $c_id !== '') {
        $query .= " AND `client_id` = '$c_id'";
    }


    $query .= "  ORDER BY `g_id` DESC";

    $query .= " LIMIT $offset, $pageSize";

    $result = mysqli_query($conn, $query);

    $row_count = mysqli_num_rows($result);

    if ($row_count > 0) {

        while ($row = mysqli_fetch_assoc($result)) {
            $client_id = $row['client_id'];
            $g_id = $row['g_id'];

            $client_query = "SELECT f_name, l_name, email, mobile, company_name FROM `clients` WHERE `c_id` = $client_id";

            $client_result = mysqli_query($conn, $client_query);

            $client_row_count = mysqli_num_rows($client_result);

            if ($client_row_count == 1) {
                $client_data = mysqli_fetch_assoc($client_result);

                $row['client_details'] = $client_data;
            }

            $contact_query = "SELECT COUNT(*) as total FROM contacts WHERE group_id = '$g_id'";

            $contact_result = mysqli_query($conn, $contact_query);

            if ($contact_result) {
                $all_contact_total = mysqli_fetch_assoc($contact_result)['total'];
                $row['contact_count'] = $all_contact_total;
            }

            $contact_data[] = $row;

        }
    }




    if (!empty($contact_data)) {
        $response = array('success' => true, 'smslog' => $contact_data, 'allcontact' => $allcontact_data, 'total' => $row_totalCount, 'message' => 'All the client details with sender data');
    } else {
        $response = array('success' => false, 'message' => 'No clients found within the date range');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
?>