<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");
include("adminlogs/admin_logs.php");
include("notification/client_notification.php");
include("jwtvalidation/jwt_validation.php");
require 'secret_key.php';
include("sendemail/sendMail.php");
include("allmails/allMail.php");


try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $id = isset($data['id']) ? mysqli_real_escape_string($conn, $data['id']) : null;
    $adminId = isset($data['adminId']) ? mysqli_real_escape_string($conn, $data['adminId']) : null;
    $senderid = isset($data['senderid']) ? mysqli_real_escape_string($conn, $data['senderid']) : null;
    $cid = isset($data['cid']) ? mysqli_real_escape_string($conn, $data['cid']) : null;
    $senderid = isset($data['senderid']) ? mysqli_real_escape_string($conn, $data['senderid']) : null;
    $reason = isset($data['reason']) ? mysqli_real_escape_string($conn, $data['reason']) : null;

    $rejectdate = date('Y-m-d H:i:s');

    // Update the status to "cancel"
    $updateStatusQuery = "UPDATE sender_details SET adminStatus = 'noapproved', nocApprovel = 'reject', submittonoc = 2, `reason` = '$reason', reject_date = '$rejectdate' WHERE `s_id` = '$id'";

    // echo $updateStatusQuery;
    $updateStatusResult = mysqli_query($conn, $updateStatusQuery);

    if ($updateStatusResult) {

        // Select the client 
        $selectQuery = "SELECT * FROM clients WHERE `c_id` = '$cid'";
        $selectResult = mysqli_query($conn, $selectQuery);

        $row_count = mysqli_num_rows($selectResult);
        if ($row_count < 1) {
            throw new Exception('Client not found');
        }

        $client_data = mysqli_fetch_assoc($selectResult);

        $c_mail = $client_data["email"];
        $client_name = $client_data["f_name"] . " " . $client_data["l_name"];
        $email_sub = $client_data["email_subscribe"];

        $query_system = "SELECT * FROM system_setting";

        $result_system = mysqli_query($conn, $query_system);

        if (mysqli_num_rows($result_system) > 0) {
            $row_system = mysqli_fetch_assoc($result_system);
            //pass row-system to email

            $mailCont = rejectSenderid($row_system, $client_name, $c_mail, $senderid, $reason);

            $postFileds = [
                'to' => $c_mail, // Recipient's email address
                'sub' => "Sender ID Request Rejected - $senderid", // Email subject
                'msg' => $mailCont, // HTML content of the email
                'from' => 'hello@ozonesender.com' // Sender's email address billing@ozonesender.com For Billing , hello@ozonesender.com For General
            ];

            $sms_details = sendMail($postFileds);

            $sms_details_array = json_decode($sms_details, true);

            $response = array('success' => true, 'message' => 'Status updated to active successfully');

            $by = $userId;
            $date = date('Y-m-d H:i:s');
            $module = 'Update Reject Sender ID';
            $message = "Administrator $userId has changed status for senderid $senderid($id).";

            insertAdminLog($conn, $by, $date, $module, $message);


            // notification
            $title = 'Reject Sender ID';
            $date = date('Y-m-d H:i:s');
            $subtitle = "Sender ID $senderid($id) has been Rejected.";
            $avatar = 'RI';
            $client_id = $cid;

            insertNotification($conn, $title, $date, $subtitle, $avatar, $client_id);
        } else {
            throw new Exception("system data not found");
        }
    } else {
        $response = array('success' => false, 'message' => 'Failed to update status to active');
    }

    echo json_encode($response);
} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
