<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');


require 'include/connection.php';
include("systemlogs/system_logs.php");
include("sendemail/sendMail.php");
include("allmails/allMail.php");





try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $id = isset($data['id']) ? mysqli_real_escape_string($conn, $data['id']) : null;
    $invoiceno = isset($data['invoiceno']) ? mysqli_real_escape_string($conn, $data['invoiceno']) : null;
    $adminId = isset($data['adminId']) ? mysqli_real_escape_string($conn, $data['adminId']) : null;

    // get client email
    $query = "SELECT * FROM clients WHERE c_id = '$id'";

    $result = mysqli_query($conn, $query);

    if (!$result) {
        throw new Exception(mysqli_error($conn));
    }

    $row = mysqli_fetch_assoc($result);

    $c_mail = $row["email"];
    $client_name = $row["f_name"] . " " . $row["l_name"];
    $company_name = $row["company_name"];
    $c_mobile = $row["mobile"];

    // get invoice details
    $query_invoice = "SELECT * FROM invoice_details WHERE invoice_HID = '$invoiceno'";

    $result_invoice = mysqli_query($conn, $query_invoice);

    if (mysqli_num_rows($result_invoice) > 0) {

        $row_invoice = mysqli_fetch_assoc($result_invoice);

        $total = $row_invoice['total'];
        $date = $row_invoice['date'];
        $description = $row_invoice['description'];

        $query_system = "SELECT * FROM system_setting";

        $result_system = mysqli_query($conn, $query_system);

        if (mysqli_num_rows($result_system) > 0) {
            $row_system = mysqli_fetch_assoc($result_system);
            //pass row-system to email

            $mailCont = paidInvoiceReminder($invoiceno, $date, $total, $row_system, $client_name, $c_mail, $company_name, $c_mobile, $description);

            $postFileds = [
                'to' => $c_mail, // Recipient's email address
                'sub' => "Payment Confirmation - Invoice $invoiceno", // Email subject
                'msg' => $mailCont, // HTML content of the email
                'from' => 'billing@ozonesender.com' // Sender's email address billing@ozonesender.com For Billing , hello@ozonesender.com For General
            ];

            $sms_details = sendMail($postFileds);

            $sms_details_array = json_decode($sms_details, true);

            $status_code = $sms_details_array['response']['ErrorCode'];
            $msg_id = $sms_details_array['response']['MessageID'];

            $response = array('success' => true, 'message' => 'mail sent', 'ErrorCode' => $status_code);

            //   systemlogs
            $client = $id;
            $date = date('Y-m-d H:i:s');
            $module = 'Invoice email payment';
            $message = "Admin $adminId - Status Code: $status_code, Message : $msg_id";

            insertSystemLog($conn, $client, $date, $module, $message);
        } else {
            throw new Exception("system data not found");
        }
        echo json_encode($response);
    } else {
        throw new Exception("invoices not found");
    }
} catch (\Throwable $th) {
    $response = array(
        'error' => true,
        'message' => 'An unexpected error occurred.',
        'details' => $th->getMessage()
    );
    echo json_encode($response);
}
