<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include ("include/connection.php");

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $id = isset($data['id']) ? mysqli_real_escape_string($conn, $data['id']) : null;
    $page = isset($data['page']) ? intval($data['page']) : 1;
    $pageSize = isset($data['pageSize']) ? intval($data['pageSize']) : 10;

    $ticket_data = array();
    $row_totalCount = 0;

    $offset = ($page - 1) * $pageSize;

    $count_query = "SELECT COUNT(*) as total  FROM ticket_details WHERE tick_id = '$id'";

    $count_result = mysqli_query($conn, $count_query);

    if ($count_result) {
        $row_totalCount = mysqli_fetch_assoc($count_result)['total'];
        $row_totalCount = intval($row_totalCount);
    }
    // .........................................................................................................

    // Fetch clients without considering 

    $query = "SELECT * FROM ticket_details WHERE tick_id = '$id'";

    $query .= "  ORDER BY `id` DESC";

    $query .= " LIMIT $offset, $pageSize";

    $result = mysqli_query($conn, $query);

    $row_count = mysqli_num_rows($result);

    if ($row_count > 0) {

        while ($row = mysqli_fetch_assoc($result)) {
            $comment_admin = $row['comment_admin'];
            $client_id = $row['client_id'];

            $admin_query = "SELECT * FROM users WHERE user_id = '$comment_admin'";

            $admin_result = mysqli_query($conn, $admin_query);

            if (mysqli_num_rows($admin_result) == 1) {
                $admin_row = mysqli_fetch_assoc($admin_result);

                $admin_name = $admin_row['f_name'] . ' ' . $admin_row['l_name'];
                $row['admin_name'] = $admin_name;

            }

            $client_query = "SELECT f_name, l_name, c_id, mobile, company_name FROM clients WHERE c_id = ?";
            $client_statement = mysqli_prepare($conn, $client_query);
            mysqli_stmt_bind_param($client_statement, "i", $client_id);
            mysqli_stmt_execute($client_statement);
            $client_result = mysqli_stmt_get_result($client_statement);
            $client_row = mysqli_fetch_assoc($client_result);

            $row['client_name'] = $client_row['f_name'] .' '. $client_row['l_name'] . ' - ('. $client_row['c_id'] . ')' ;

            $ticket_data[] = $row;
        }

    }


    if (!empty($ticket_data)) {
        $response = array('success' => true, 'ticket' => $ticket_data, 'total' => $row_totalCount, 'message' => 'all technocal ticket');
    } else {
        $response = array('success' => false, 'message' => 'No tickets found');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}

?>