<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $json_data = file_get_contents('php://input');
    $data = json_decode($json_data, true);

    $id = isset($data['id']) ? $data['id'] : null;

    $query = "SELECT * FROM logs WHERE `clog_id` = '$id'";

    $result = mysqli_query($conn, $query);

    $row_count = mysqli_num_rows($result);

    if ($row_count === 1) {
        $smslog_data = mysqli_fetch_assoc($result);

        $client_id = $smslog_data['client_id'];
        
        $serverResponse = json_decode($smslog_data["serverResponse"]);
        
        if (is_object($serverResponse)) {
            $smslog_data["serverResponse"] = $serverResponse;

        } 

        $client_query = "SELECT f_name, l_name, c_id, mobile, company_name FROM clients WHERE c_id = ?";
        $client_statement = mysqli_prepare($conn, $client_query);
        mysqli_stmt_bind_param($client_statement, "i", $client_id);
        mysqli_stmt_execute($client_statement);
        $client_result = mysqli_stmt_get_result($client_statement);

        if ($client_row = mysqli_fetch_assoc($client_result)) {
            $smslog_data['client_details'] = $client_row;
        }

        $response = array('success' => true, 'sms' => $smslog_data, 'message' => 'Authentication successful');
    } else {
        $response = array('success' => false, 'message' => 'Invalid user id');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}

?>