<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $json_data = file_get_contents('php://input');
    $data = json_decode($json_data, true);

    $id = isset($data['id']) ? $data['id'] : null;

    $query = "SELECT * FROM invoice_header WHERE `inovideHID` = '$id'";
    $result = mysqli_query($conn, $query);

    if ($result && mysqli_num_rows($result) === 1) {
        $oneinvoice = mysqli_fetch_assoc($result);
            
        $invoice_id = $oneinvoice['inovideHID'];
        $client_id = $oneinvoice['client_id'];

        $invoice_query = "SELECT * FROM `invoice_details` WHERE `invoice_HID` = $invoice_id";
        $invoice_result = mysqli_query($conn, $invoice_query);

        if ($invoice_result) {
            $invoice_details = mysqli_fetch_assoc($invoice_result);
            $oneinvoice['invoice_data'] = $invoice_details;
        }

        $client_query = "SELECT * FROM `clients` WHERE `c_id`= $client_id";
        $client_result =  mysqli_query($conn, $client_query);

        $client_row = mysqli_num_rows($client_result);

        if($client_row===1) {
            $client_details = mysqli_fetch_assoc($client_result);
        }

        $response = array('success' => true, 'invoice' => $oneinvoice, 'client' => $client_details, 'message' => 'Authentication successful');
    } else {
        $response = array('success' => false, 'message' => 'Invalid user id');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}

?>
