<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $searchValue = isset($data['searchValue']) ? mysqli_real_escape_string($conn, $data['searchValue']) : null;

    $client_data = array();
    $sender_data = array();
    $logs_data = array();
 
    $clients_query = "SELECT * FROM clients WHERE status = 1 AND (c_id = '$searchValue' OR mobile = '$searchValue' OR email = '$searchValue' OR company_name = '$searchValue' OR f_name = '$searchValue')";

    $clients_result = mysqli_query($conn, $clients_query);

    if (!$clients_result) {
        throw new Exception('Error executing the query');
    }

    if($clients_result) {
        while ($client_row = mysqli_fetch_assoc($clients_result)) {
            $client_data[] = $client_row;
        }
    }


    $sender_query = "SELECT * FROM sender_details WHERE status = 'Active' AND ('$searchValue' IN (s_id, sender_id, client_id)) AND client_id != 0";

    $sender_result = mysqli_query($conn, $sender_query);

    if($sender_result) {
        while ($sender_row = mysqli_fetch_assoc($sender_result)) {
            $sender_data[] = $sender_row;
        }
    }

    $logs_query = "SELECT * FROM logs WHERE (clog_id = '$searchValue' OR sender_id = '$searchValue' OR client_id = '$searchValue' OR send_to = '$searchValue') ORDER BY `clog_id` DESC LIMIT 5 ";

    $logs_result = mysqli_query($conn, $logs_query);

    if($logs_result) {
        while ($logs_row = mysqli_fetch_assoc($logs_result)) {
            $logs_data[] = $logs_row;
        }
    }

    if (!empty($client_data) || !empty($sender_data) || !empty($logs_data)) {
        $response = array('success' => true, 'client' => $client_data, 'sender' => $sender_data, 'logs' => $logs_data,'message' => 'client found ');
    } else {
        $response = array('success' => false, 'message' => 'No clients found');
    }

    echo json_encode($response);

    // Close the database connection
    mysqli_close($conn);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
?>