<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

require 'vendor/autoload.php';
require 'secret_key.php';
use \Firebase\JWT\JWT;

include ("include/connection.php");
include ("adminlogs/admin_logs.php");

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);
    // print_r($data);
    // Check if the required fields are present in the JSON data
    if (!isset($data['username']) || !isset($data['password'])) {
        throw new Exception('Missing required fields');
    }

    // Extract user credentials from the JSON data
    $user_email = mysqli_real_escape_string($conn, $data['username']);
    $user_password = mysqli_real_escape_string($conn, $data['password']);

    // Your authentication logic using parameterized query
    $query = "SELECT * FROM `users` WHERE `username` = ? AND `status` = 1";
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, 's', $user_email);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);

    if (!$result) {
        throw new Exception('Error executing the query: ' . mysqli_error($conn));
    }

    $user_data = mysqli_fetch_assoc($result);

    if (!$user_data) {
        throw new exception('wrong email');
    }

    $hashedPasswordInDB = $user_data['password'];

    if (password_verify($user_password, $hashedPasswordInDB)) {
        unset($user_data['password']);

        $role_id = $user_data['role_id'];

        $query_role = "SELECT privilege FROM `user_role` WHERE `id` = ?";
        $stmt = mysqli_prepare($conn, $query_role);
        mysqli_stmt_bind_param($stmt, 'i', $role_id);
        mysqli_stmt_execute($stmt);
        $result_role = mysqli_stmt_get_result($stmt);

        if($result){
            $priviledge = mysqli_fetch_assoc($result_role);
            $user_data['privilege'] = $priviledge;
        }

        // JWT access token generation
        $secretKey = $secret_Key;
        $issuedAt = time();
        $expirationTime = $issuedAt + 3600;  // jwt valid for 1 hour from the issued time
        $payload = array(
            'iat' => $issuedAt,
            'exp' => $expirationTime,
            'iss' => 'https://smsadmin.ozonesender.com',
            'email' => $user_email,
            'user_id' => $user_data['user_id']
        );

        $jwt = JWT::encode($payload, $secretKey, 'HS256');


        // JWT refresh token generation
        $refreshTokenSecretKey = 'your_refresh_token';
        $refreshTokenExpTime = $issuedAt + 86400;  // JWT valid for 7 days from the issued time
        $refreshTokenPayload = array(
            'iat' => $issuedAt,
            'exp' => $refreshTokenExpTime,
            'iss' => 'https://smsadmin.ozonesender.com',
            'email' => $user_email,
            'user_id' => $user_data['user_id']
        );

        $refresh = JWT::encode($refreshTokenPayload, $refreshTokenSecretKey, 'HS256');

        // Add the JWT token to the response
        $response = array(
            'success' => true,
            'user' => $user_data,
            'jwt' => $jwt,
            'refresh' => $refresh,
            'message' => 'Authentication successful'
        );

        $by = $user_data['user_id'];
        $date = date('Y-m-d H:i:s');
        $module = 'admin login';
        $message = "admin $by login successfully.";

        insertAdminLog($conn, $by, $date, $module, $message);
        echo json_encode($response);

    } else {
        throw new Exception('Current password is incorrect');

    }

} catch (Exception $e) {
    // Handle exceptions (e.g., missing fields or database error)
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}

?>