<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include ("include/connection.php");

require 'vendor/autoload.php';
require 'secret_key.php';
include("jwtvalidation/jwt_validation.php");
use \Firebase\JWT\JWT;



try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    // Validate the JWT token
    $headers = apache_request_headers();
    $refreshTokenSecretKey = 'your_refresh_token';
    $decodedToken = validateJWT($headers, $refreshTokenSecretKey);

    if (!$decodedToken) {
        throw new Exception('Token validation failed');
    }

    if ($decodedToken) {

        $secretKey = $secret_Key;
        $issuedAt = time();
        $expirationTime = $issuedAt + 3600;  // jwt valid for 1 hour from the issued time
        $payload = array(
            'iat' => $issuedAt,
            'exp' => $expirationTime,
            'iss' => 'https://smsadmin.ozonesender.com',
            'email' => 'smsadmin@gmail.com',
            'user_id' => $decodedToken['user_id']
        );

        $jwt = JWT::encode($payload, $secretKey, 'HS256');
       

        $response = array('success' => true, 'accessToken' => $jwt, 'message' => 'New Access token');
    } else {
        $response = array('success' => false, 'message' => 'Failed to create a token');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
?>