<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");
include("adminlogs/admin_logs.php");

try {
    if($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $json_data = file_get_contents('php://input');
    $data = json_decode($json_data, true);

    // Assuming you have all the necessary fields in your frontend form
    $email = isset($data['email']) ? mysqli_real_escape_string($conn, $data['email']) : '';

    $emailCheckQuery = "SELECT * FROM users WHERE username = '$email'";
    $emailCheckResult = mysqli_query($conn, $emailCheckQuery);

    if (mysqli_num_rows($emailCheckResult) == 0) {
        throw new Exception('Sorry, the email is not registered. Please check the email or sign up for a new account.');
    }
    
    function generateRandomString($length = 6) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $randomString = '';
    
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, strlen($characters) - 1)];
        }
    
        return $randomString;
    }
    
    $randomString = generateRandomString();
    echo $randomString . "\n";
    
    // $updateSendeQuery = "UPDATE sender_details SET `trans_per_msg` = '$transCost', `promo_per_msg` = '$promoCost' WHERE `client_id` = '$id'";
    // $updateSenderResult = mysqli_query($conn, $updateSenderQuery);

    
    $response = array('success' => true, 'message' => 'User password updated successfully');

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
?>