<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include ("include/connection.php");
include ("adminlogs/admin_logs.php");

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $status = isset($data['status']) ? mysqli_real_escape_string($conn, $data['status']) : null;
    $id = isset($data['id']) ? mysqli_real_escape_string($conn, $data['id']) : null;

   
    // Update trans_per_msg and promocost in clients table
    $updateClientQuery = "UPDATE users SET `email_subscribe` = '$status' WHERE `user_id` = '$id'";
    $updateClientResult = mysqli_query($conn, $updateClientQuery);

    $affectedRows = mysqli_affected_rows($conn); 

    if ($affectedRows > 0) {
        $response = array('success' => true, 'message' => 'Unsubscribe succesfully');

         // admin logs
         $by = $id;
         $date = date('Y-m-d H:i:s');
         $module = 'Email Subscribe';
         $message = "Administrator $id has changed email subcribe status.";
 
         insertAdminLog($conn, $by, $date, $module, $message);
    } else {
        $response = array('success' => false, 'message' => 'Unsubscribe failed. Please try again.');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}

?>