<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include ("include/connection.php");
include ("jwtvalidation/jwt_validation.php");
require 'secret_key.php';

$uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
$uri = explode('/', $uri);

$action = $uri[3];

try {

    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    if ($action === 'technical') {

        $page = isset($data['page']) ? intval($data['page']) : 1;
        $pageSize = isset($data['pageSize']) ? intval($data['pageSize']) : 10;

        $technical_data = array();
        $row_totalCount = 0;

        $offset = ($page - 1) * $pageSize;

        $count_query = "SELECT COUNT(*) as total FROM ticket_header WHERE `department` = 'technical' AND `status` = 'close'";

        $count_result = mysqli_query($conn, $count_query);

        if ($count_result) {
            $row_totalCount = mysqli_fetch_assoc($count_result)['total'];
            $row_totalCount = intval($row_totalCount);
        }
        // ........................................................................................................

        // Fetch clients without considering 

        $query = "SELECT * FROM ticket_header WHERE `department` = 'technical' AND `status` = 'close' ";

        $query .= "  ORDER BY `id` DESC";

        $query .= " LIMIT $offset, $pageSize";

        $result = mysqli_query($conn, $query);

        $row_count = mysqli_num_rows($result);

        if ($row_count > 0) {

            while ($row = mysqli_fetch_assoc($result)) {
                $technical_data[] = $row;
            }

        }


        if (!empty($technical_data)) {
            $response = array('success' => true, 'ticket' => $technical_data, 'total' => $row_totalCount, 'message' => 'all technocal ticket');
        } else {
            $response = array('success' => false, 'message' => 'No tickets found');
        }

        echo json_encode($response);
    } elseif ($action === 'billing') {

        $page = isset($data['page']) ? intval($data['page']) : 1;
        $pageSize = isset($data['pageSize']) ? intval($data['pageSize']) : 10;

        $technical_data = array();
        $row_totalCount = 0;

        $offset = ($page - 1) * $pageSize;

        $count_query = "SELECT COUNT(*) as total FROM ticket_header WHERE `department` = 'billing' AND `status` = 'close'";

        $count_result = mysqli_query($conn, $count_query);

        if ($count_result) {
            $row_totalCount = mysqli_fetch_assoc($count_result)['total'];
            $row_totalCount = intval($row_totalCount);
        }
        // ........................................................................................................

        // Fetch clients without considering 

        $query = "SELECT * FROM ticket_header WHERE `department` = 'billing' AND `status` = 'close' ";

        $query .= "  ORDER BY `id` DESC";

        $query .= " LIMIT $offset, $pageSize";

        $result = mysqli_query($conn, $query);

        $row_count = mysqli_num_rows($result);

        if ($row_count > 0) {

            while ($row = mysqli_fetch_assoc($result)) {
                $technical_data[] = $row;
            }

        }


        if (!empty($technical_data)) {
            $response = array('success' => true, 'ticket' => $technical_data, 'total' => $row_totalCount, 'message' => 'all technocal ticket');
        } else {
            $response = array('success' => false, 'message' => 'No tickets found');
        }

        echo json_encode($response);

    } else if ($action === 'sales') {

        $page = isset($data['page']) ? intval($data['page']) : 1;
        $pageSize = isset($data['pageSize']) ? intval($data['pageSize']) : 10;

        $technical_data = array();
        $row_totalCount = 0;

        $offset = ($page - 1) * $pageSize;

        $count_query = "SELECT COUNT(*) as total FROM ticket_header WHERE `department` = 'sales' AND `status` = 'close'";

        $count_result = mysqli_query($conn, $count_query);

        if ($count_result) {
            $row_totalCount = mysqli_fetch_assoc($count_result)['total'];
            $row_totalCount = intval($row_totalCount);
        }
        // ........................................................................................................

        // Fetch clients without considering 

        $query = "SELECT * FROM ticket_header WHERE `department` = 'sales' AND `status` = 'close' ";

        $query .= "  ORDER BY `id` DESC";

        $query .= " LIMIT $offset, $pageSize";

        $result = mysqli_query($conn, $query);

        $row_count = mysqli_num_rows($result);

        if ($row_count > 0) {

            while ($row = mysqli_fetch_assoc($result)) {
                $technical_data[] = $row;
            }

        }


        if (!empty($technical_data)) {
            $response = array('success' => true, 'ticket' => $technical_data, 'total' => $row_totalCount, 'message' => 'all technocal ticket');
        } else {
            $response = array('success' => false, 'message' => 'No tickets found');
        }

        echo json_encode($response);
    }

} catch (\Throwable $th) {

    $response = array('success' => false, 'message' => $th->getMessage());
    echo json_encode($response);
}
?>