<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");
include("adminlogs/admin_logs.php");

try {
    if($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $json_data = file_get_contents('php://input');
    $data = json_decode($json_data, true);

    // Assuming you have all the necessary fields in your frontend form
    $id = isset($data['id']) ? intval($data['id']) : 0;
    $password = isset($data['password']) ? mysqli_real_escape_string($conn, $data['password']) : '';
    $currentPassword = isset($data['currentPassword']) ? mysqli_real_escape_string($conn, $data['currentPassword']) : '';

    // Check if the ID is valid
    if($id <= 0) {
        throw new Exception('Invalid client ID');
    }

    $query = "SELECT * FROM users WHERE user_id =$id";

    $result = mysqli_query($conn, $query);

    if(!$result) {
        throw new Exception('Failed to check current password');
    }

    $userData = mysqli_fetch_assoc($result);
    $hashedPasswordInDB = $userData['password'];

    if(password_verify($currentPassword, $hashedPasswordInDB)) {
        $hashedNewPassword = password_hash($password, PASSWORD_DEFAULT);

        $updateClientQuery = "UPDATE users SET `password` = '$hashedNewPassword' WHERE user_id = $id";

        // Execute the update query
        $updateClientResult = mysqli_query($conn, $updateClientQuery);

        $response = array('success' => true, 'message' => 'User password updated successfully');

            $by = $id;
            $date = date('Y-m-d H:i:s');
            $module = 'Change admin Password';
            $message = "Changed password for user $id.";
    
            insertAdminLog($conn, $by, $date, $module, $message);

    } else {
        throw new Exception('Current password is incorrect');

    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
?>