<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include ("include/connection.php");
include ("jwtvalidation/jwt_validation.php");
require 'secret_key.php';

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $startDate = isset($data['startdate']) ? mysqli_real_escape_string($conn, $data['startdate']) : null;
    $endDate = isset($data['enddate']) ? mysqli_real_escape_string($conn, $data['enddate']) : null;
    $clientID = isset($data['clientID']) ? mysqli_real_escape_string($conn, $data['clientID']) : null;
    $value = isset($data['value']) ? mysqli_real_escape_string($conn, $data['value']) : null;
    $page = isset($data['page']) ? intval($data['page']) : 0;
    $pageSize = isset($data['pageSize']) ? intval($data['pageSize']) : 10;

    $offset = ($page) * $pageSize;

    $billing_data = array();
    $row_totalCount = 0;

    // count total data
    $countQuery = "SELECT COUNT(*) as total FROM account_history
    WHERE byID = '$clientID'";

    if ($startDate !== null && $endDate !== null) {
        $startDate .= ' 00:00:00';
        $endDate .= ' 23:59:59';
        $countQuery .= " AND `datetime` BETWEEN '$startDate' AND '$endDate'";
    }

    if ($value !== null && $value !== '') {
        $countQuery .= " AND `type` = '$value'";
    }

    $countResult = mysqli_query($conn, $countQuery);
    $row_totalCount = mysqli_fetch_assoc($countResult)['total'];

    $row_totalCount = intval($row_totalCount);

    // ........................................................................................................

    // Fetch clients based on sender_id
    $query = "SELECT * FROM account_history WHERE byID = '$clientID'";

    if ($startDate !== null && $endDate !== null) {
        $startDate .= ' 00:00:00';
        $endDate .= ' 23:59:59';
        $query .= " AND `datetime` BETWEEN '$startDate' AND '$endDate'";
    }

    if ($value !== null && $value !== '') {
        $query .= " AND `type` = '$value'";
    }

    $query .= "  ORDER BY `id` DESC";

    $query .= " LIMIT $offset, $pageSize";

    $result = mysqli_query($conn, $query);

    $row_count = mysqli_num_rows($result);

    if ($row_count > 0) {

        while ($row = mysqli_fetch_assoc($result)) {

            $billing_data[] = $row;
        }

    }


    if (!empty($billing_data)) {
        $response = array('success' => true, 'billing' => $billing_data, 'total' => $row_totalCount, 'message' => 'billing found within the date range');
    } else {
        $response = array('success' => false, 'message' => 'No billing found within the date range');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}

?>