<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");
include("jwtvalidation/jwt_validation.php");
require 'secret_key.php';

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

 
    $page = isset($data['page']) ? intval($data['page']) : 0;
    $pageSize = isset($data['pageSize']) ? intval($data['pageSize']) : 10;

    $gateway_data = array();

    $offset = ($page) * $pageSize;

    $row_totalCount = 0;

    $count_query = "SELECT COUNT(*) as total FROM gateway";

    $count_result = mysqli_query($conn, $count_query);

    if ($count_result) {
        $row_totalCount = mysqli_fetch_assoc($count_result)['total'];
        $row_totalCount = intval($row_totalCount);
    }

    // .........................................................................................................


    $query = "SELECT * FROM gateway";

    $params = [];
    $types = "";

    // if ($c_id !== null && $c_id !== '') {
    //     $query .= " AND `client_id` = ?";
    //     $params[] = $c_id;
    //     $types .= "s"; 
    // }

    $query .= " ORDER BY `id` DESC";
    $query .= " LIMIT ?, ?";

    // Add limit parameters
    $params[] = $offset;
    $params[] = $pageSize;
    $types .= "ii"; // Two integers for LIMIT

    // Prepare statement
    $sender_statement = mysqli_prepare($conn, $query);

    // Bind parameters dynamically
    if ($params) {
        mysqli_stmt_bind_param($sender_statement, $types, ...$params);
    }

    mysqli_stmt_execute($sender_statement);
    $result = mysqli_stmt_get_result($sender_statement);

    while ($row = mysqli_fetch_assoc($result)) {

        $gateway_data[] = $row;
    }

    // Close statement
    mysqli_stmt_close($sender_statement);


    if (!empty($gateway_data)) {
        $response = array('success' => true, 'gateway' => $gateway_data, 'total' => $row_totalCount, 'message' => 'All the client details with sender data');
    } else {
        $response = array('success' => false, 'message' => 'No clients found within the date range');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
?>