<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
        throw new Exception('Invalid request method');
    }

    $query = "SELECT * FROM gateway WHERE `status` = 'active'"; 
    
    $result = mysqli_query($conn, $query);

    $row_count = mysqli_num_rows($result);

    if ($row_count > 0) {
        $gateway_data = array();

        while ($row = mysqli_fetch_assoc($result)) {
            
            $gateway_data[] = $row;
        }

        $response = array('success' => true, 'gateway' => $gateway_data, 'message' => 'All the Gateway data');
    } else {
        $response = array('success' => false, 'message' => 'No gateway found');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
?>

