<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
        throw new Exception('Invalid request method');
    }

    $query = "SELECT * FROM clients"; 
    
    $result = mysqli_query($conn, $query);

    $row_count = mysqli_num_rows($result);

    if ($row_count > 0) {
        $client_data = array();

        while ($row = mysqli_fetch_assoc($result)) {
            // Fetch sender data for each client
            $client_data[] = $row;
        }

        $response = array('success' => true, 'client' => $client_data, 'message' => 'All the client details');
    } else {
        $response = array('success' => false, 'message' => 'No clients found');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
?>
