<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include ("include/connection.php");
include ("jwtvalidation/jwt_validation.php");
require 'secret_key.php';

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $startDate = isset($data['startdate']) ? mysqli_real_escape_string($conn, $data['startdate']) : null;
    $endDate = isset($data['enddate']) ? mysqli_real_escape_string($conn, $data['enddate']) : null;
    $c_id = isset($data['c_id']) ? mysqli_real_escape_string($conn, $data['c_id']) : null;
    $role = isset($data['role']) ? mysqli_real_escape_string($conn, $data['role']) : null;
    $adminStatus = isset($data['adminStatus']) ? mysqli_real_escape_string($conn, $data['adminStatus']) : null;
    $sid = isset($data['sid']) ? mysqli_real_escape_string($conn, $data['sid']) : null;
    $gateway = isset($data['gateway']) ? mysqli_real_escape_string($conn, $data['gateway']) : null;
    $page = isset($data['page']) ? intval($data['page']) : 0;
    $pageSize = isset($data['pageSize']) ? intval($data['pageSize']) : 10;

    $sender_data = array();

    $offset = ($page) * $pageSize;

    $row_totalCount = 0;

    $count_query = "SELECT COUNT(*) as total FROM sender_details WHERE `status` = 'Active' AND nocApprovel = 'approved'";

    if ($startDate !== null && $endDate !== null) {
        $startDate .= ' 00:00:00';
        $endDate .= ' 23:59:59';
        $count_query .= " AND `date` BETWEEN '$startDate' AND '$endDate'";
    }

    if ($role !== null && $role !== '') {
        $count_query .= " AND `sender_id` = '$role'";
    }

    if ($adminStatus !== null && $adminStatus !== '') {
        $count_query .= " AND `adminStatus` = '$adminStatus'";
    }

    if ($sid !== null && $sid !== '') {
        $count_query .= " AND `s_id` = '$sid'";
    }

    if ($c_id !== null && $c_id !== '') {
        $count_query .= " AND `client_id` = '$c_id'";
    }

    if ($gateway !== null && $gateway !== '') {
        $count_query .= " AND `defaultGatway` = '$gateway'";
    }


    $count_result = mysqli_query($conn, $count_query);

    if ($count_result) {
        $row_totalCount = mysqli_fetch_assoc($count_result)['total'];
        $row_totalCount = intval($row_totalCount);
    }
    // .........................................................................................................

    $query = "SELECT * FROM sender_details WHERE `status` = 'Active' AND nocApprovel = 'approved'";

    if ($startDate !== null && $endDate !== null) {
        $startDate .= ' 00:00:00';
        $endDate .= ' 23:59:59';
        $query .= " AND `date` BETWEEN '$startDate' AND '$endDate'";
    }

    if ($role !== null && $role !== '') {
        $query .= " AND `sender_id` = '$role'";
    }

    if ($adminStatus !== null && $adminStatus !== '') {
        $query .= " AND `adminStatus` = '$adminStatus'";
    }

    if ($sid !== null && $sid !== '') {
        $query .= " AND `s_id` = '$sid'";
    }

    if ($c_id !== null && $c_id !== '') {
        $query .= " AND `client_id` = '$c_id'";
    }

    if ($gateway !== null && $gateway !== '') {
        $query .= " AND `defaultGatway` = '$gateway'";
    }

    $query .= "  ORDER BY `s_id` DESC";

    $query .= " LIMIT $offset, $pageSize";

    $result = mysqli_query($conn, $query);

    $row_count = mysqli_num_rows($result);

    if ($row_count > 0) {

        while ($row = mysqli_fetch_assoc($result)) {

            $client_id = $row['client_id'];
            $sender_id = $row['sender_id'];

            $client_query = "SELECT f_name,l_name,email,mobile,company_name FROM `clients` WHERE `c_id` = $client_id";

            $client_result = mysqli_query($conn, $client_query);

            $client_row_count = mysqli_num_rows($client_result);

            if ($client_row_count == 1) {
                $client_row = mysqli_fetch_assoc($client_result);
                $client_data = $client_row;

                $row['client_details'] = $client_data;

            }

            $log_query = "SELECT clog_id,create_date,serverResponse FROM `logs` WHERE `sender_id` = '$sender_id' ORDER BY create_date DESC LIMIT 1";

            $log_result = mysqli_query($conn, $log_query);

            if ($log_result) {
                $log_row = mysqli_fetch_assoc($log_result);
                $log_data = $log_row;

                $row['log_details'] = $log_data;

            }
            $sender_data[] = $row;
        }

    }


    if (!empty($sender_data)) {
        $response = array('success' => true, 'sender' => $sender_data, 'total' => $row_totalCount, 'message' => 'All the client details with sender data');
    } else {
        $response = array('success' => false, 'message' => 'No clients found within the date range');
    }

    echo json_encode($response);

} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
?>