<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include("include/connection.php");
include("adminlogs/admin_logs.php");
include("jwtvalidation/jwt_validation.php");
require 'secret_key.php';
include("sendemail/sendMail.php");
include("allmails/allMail.php");

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    $headers = apache_request_headers();
    $secretKey = $secret_Key;
    $decodedToken = validateJWT($headers, $secretKey);

    $userId = $decodedToken['user_id'];

    // Assuming your JSON data is sent in the request body
    $json_data = file_get_contents('php://input');

    // Decode the JSON data
    $data = json_decode($json_data, true);

    $id = isset($data['id']) ? mysqli_real_escape_string($conn, $data['id']) : null;
    $adminId = isset($data['adminId']) ? mysqli_real_escape_string($conn, $data['adminId']) : null;


    // Update the status to "cancel"
    $updateStatusQuery = "UPDATE clients SET `status` = 1, api_status = 1 WHERE `c_id` = '$id'";
    $updateStatusResult = mysqli_query($conn, $updateStatusQuery);

    if ($updateStatusResult) {

        // Select the client 
        $selectQuery = "SELECT * FROM clients WHERE `c_id` = '$id'";
        $selectResult = mysqli_query($conn, $selectQuery);

        $row_count = mysqli_num_rows($selectResult);
        if ($row_count < 1) {
            throw new Exception('Client not found');
        }

        $client_data = mysqli_fetch_assoc($selectResult);

        $c_mail = $client_data["email"];
        $client_name = $client_data["f_name"] . " " . $client_data["l_name"];

          //all sender ids
          $sender_query = "SELECT sender_id FROM sender_details WHERE client_id = ?";
          $sender_statment = mysqli_prepare($conn, $sender_query);
          mysqli_stmt_bind_param($sender_statment, 'i', $id);
          mysqli_stmt_execute($sender_statment);
          $sender_result = mysqli_stmt_get_result($sender_statment);
  
          $sender_count = mysqli_num_rows($sender_result);
  
          if ($sender_count < 1) {
              throw new Exception('No sender found for this client');
          }
  
          $sender_array = [];
  
          while($sender_row = mysqli_fetch_assoc($sender_result)){
              $sender_array[] = $sender_row;
          }

        $query_system = "SELECT * FROM system_setting";

        $result_system = mysqli_query($conn, $query_system);

        if (mysqli_num_rows($result_system) > 0) {
            $row_system = mysqli_fetch_assoc($result_system);
            //pass row-system to email

            $mailCont = activeClient($row_system, $client_name, $c_mail, $sender_array);

            $postFileds = [
                'to' => $c_mail, // Recipient's email address
                'sub' => ' Your Account Has Been Reinstated', // Email subject
                'msg' => $mailCont, // HTML content of the email
                'from' => 'hello@ozonesender.com' // Sender's email address billing@ozonesender.com For Billing , hello@ozonesender.com For General
            ];

            $sms_details = sendMail($postFileds);

            $sms_details_array = json_decode($sms_details, true);

            $response = array('success' => true, 'message' => 'Status updated to active successfully');

            $by = $userId;
            $date = date('Y-m-d H:i:s');
            $module = 'Active the client';
            $message = "Admin $userId activated client $id.";

            insertAdminLog($conn, $by, $date, $module, $message);
        } else {
            throw new Exception("system data not found");
        }
    } else {
        $response = array('success' => false, 'message' => 'Failed to update status to active');
    }

    echo json_encode($response);
} catch (Exception $e) {
    $response = array('success' => false, 'message' => $e->getMessage());
    echo json_encode($response);
}
